#include <bits/stdc++.h>
#define ll long long
#define MAXN 305

using namespace std;

struct Ponco
{
  ll w, v;
};

struct Result
{
  ll w, v;
  vector<int> idx;
};

ll N, W;
float E;
Ponco a[MAXN];
Result res[MAXN];

void gen(vector<Ponco> &poncos, vector<Result> &res, int i, int j, int w, int v, vector<int> idx)
{
  if (j == (int)poncos.size())
  {
    res.push_back({w, v, idx});
    return;
  }

  gen(poncos, res, i, j + 1, w, v, idx);
  idx.push_back(i + j);
  gen(poncos, res, i, j + 1, poncos[j].w + w, poncos[j].v + v, idx);
}

void clean(vector<Result> &res)
{
  sort(res.begin(), res.end(), [](Result &a, Result &b)
       {
    if (a.w != b.w) return a.w < b.w;
    return a.v < b.v; });

  int i = 0;
  for (int j = 0; j < (int)res.size(); j++)
  {
    if (res[i].w < res[j].w && res[i].v < res[j].v)
    {
      i++;
      swap(res[i], res[j]);
    }
    else if (res[i].v < res[j].v)
    {
      swap(res[i], res[j]);
    }
  }
  i++;
  res.resize(i);
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> W >> E;
  for (int i = 0; i < N; i++)
  {
    int w, v;
    cin >> w >> v;
    a[i] = {w, v};
  }

  int half = N / 2;
  vector<Ponco> left(a, a + half);
  vector<Ponco> right(a + half, a + N);

  vector<Result> left_res, right_res;
  gen(left, left_res, 0, 0, 0, 0, {});
  gen(right, right_res, half, 0, 0, 0, {});

  clean(left_res);
  clean(right_res);

  int val = 0;
  vector<int> idx;

  for (int i = 0, j = right_res.size() - 1; i < (int)left_res.size(); i++)
  {
    while (j >= 0 && left_res[i].w + right_res[j].w > W)
    {
      j--;
    }

    if (j >= 0)
    {
      int sum = left_res[i].v + right_res[j].v;
      if (sum > val)
      {
        val = sum;
        idx = left_res[i].idx;
        idx.insert(idx.end(), right_res[j].idx.begin(), right_res[j].idx.end());
      }
    }
  }

  cout << idx.size() << "\n";
  for (int i : idx)
  {
    cout << (i + 1) << " ";
  }
  cout << "\n";
}